﻿using System.Collections.Generic;

namespace Microscopic_Traffic_Simulator___Model.CellularTopologyObjects.CellWalkers
{
    /// <summary>
    /// Cell walker in forward direction.
    /// </summary>
    class ForwardCellWalker : CellWalker
    {
        /// <summary>
        /// Initialize cell walker in forward direction.
        /// </summary>
        /// <param name="cell">Cell from the walk starts.</param>
        internal ForwardCellWalker(Cell cell) : base(cell) { }

        /// <summary>
        /// Method for obtaining walked cells in forward direction.
        /// </summary>
        /// <returns>Walked cells.</returns>
        internal override IEnumerable<Cell> GetNext()
        {
            if (cell != null)
            {
                yield return cell;
                while (cell.FollowingCell != null)
                {
                    cell = cell.FollowingCell;
                    yield return cell;
                }
            }
        }
    }
}
